if((test-path "cards_section*.xml") -and (test-path "fusion_recipes_cj2.xml")){
	$xmlcardslist = @()
	foreach($xml in Get-ChildItem "cards_section*.xml"){
		$xmlcardslist += [xml](Get-Content $xml)
	}
	$carddata = @{}
	$carddata_name = @{}
	foreach($list in $xmlcardslist){
		foreach($card in $list.root.unit){
			$name = $card.name
			$carddata.add([int]$card.id,$name)
			$carddata_name.add($name,[int]$card.id)
			if(($card.selectnodes("upgrade") | measure).count -gt 0){
				foreach($upg in $card.upgrade){
					$carddata.add([int]$upg.card_id,($name+"-"+$upg.level))
				}
			}
		}
	}
	$fusions = [xml](Get-Content "fusion_recipes_cj2.xml")
	$fusiondata = @{}
	foreach($fus in $fusions.root.fusion_recipe){
		$resource = @()
		foreach($res in $fus.resource){
			for($i=0;$i-lt$res.number;$i++){
				$resource += $carddata.get_item([int]$res.card_id)
			}
		}
		$fusiondata.add($carddata.get_item([int]$fus.card_id),$resource)
	}
	
	$kilep=$false
	while(-not $kilep){
	clear
	Write-Host "This script tells you which cards do you need to fuse the card you don't know."
	[console]::setcursorposition(8,3)
	Write-Host "Please enter the card's name (e.g.: Necrogeddon) and press enter"
	[console]::setcursorposition(25,8)
	Write-Host "------------------------------"
	[console]::setcursorposition(22,7)
	$cardname = Read-Host " "
	while ([string]::IsNullOrEmpty($cardname)){
		[console]::setcursorposition(7,10)
		Write-Host "Can not tell you the answer without a card name! Please try again!" -ForegroundColor "Red"
		[console]::setcursorposition(22,7)
		$cardname = Read-Host " "
	}
	
	if ($fusiondata.get_item([string]$cardname) -eq $null){
		clear
		[console]::setcursorposition(17,3)
		Write-Host "Could not found the card in the fusions list." -ForegroundColor "Red"
	}else{
		clear
		[console]::setcursorposition(19,3)
		Write-Host "Success! I have found the cards you need:" -ForegroundColor "Green"
		[console]::setcursorposition(0,5)
		foreach($card in $fusiondata.get_item([string]$cardname)){
			[console]::setcursorposition((80-$card.length)/2,[console]::CursorTop+1)
			$card
		}
	}
	[console]::setcursorposition(17,[console]::CursorTop+3)
	Write-Host "Press any key to continue, or press Q to quit."
	$Host.UI.RawUI.FlushInputBuffer();
	$gomb = $Host.UI.RawUI.ReadKey("NoEcho,IncludeKeyUp").Character
	$kilep = $gomb -eq "q"
	}

	
	
}else{"Please run this script in TUO data folder according to instructions!"}